<?php
/**
 * @package WordPress
 * @subpackage jPortal
 */

if ( post_password_required() ) : ?>
	<p><?php _e('Enter your password to view comments.'); ?></p>
<?php return; endif; 

if (have_comments() || comments_open()) { ?>
	<div id="comments-header">
		<div class="clearfix">
		<?php if (comments_open()) { ?>
  			<p class="comments-feed"><a href="<?php echo get_post_comments_feed_link(); ?>"><?php _e('Comments feed for this article', 'jPortal'); ?></a></p>
  		<?php } ?>
  		</div>
  		<?php if (pings_open()) { ?>
		<p class="trackback-link"><?php printf(__('Trackback link: %s', 'jPortal'),
			'<a href="' . get_trackback_url() . '">' . get_trackback_url() . '</a>') .'</p>'; ?></p>
		<?php } ?>
	</div>

	<?php if ( have_comments() ) : ?>
		<ol id="commentlist">
			<?php foreach ($comments as $comment) : ?>
				<li <?php comment_class(); ?> id="comment-<?php comment_ID() ?>">
				<?php echo get_avatar( $comment, 32 ); ?>
				<?php comment_text() ?>
				<p><cite><?php comment_type(_x('Comment', 'jPortal'), __('Trackback'), __('Pingback')); ?> <?php _e('by'); ?> <?php comment_author_link() ?> &#8212; <?php comment_date() ?> @ <a href="#comment-<?php comment_ID() ?>"><?php comment_time() ?></a></cite> <?php edit_comment_link(__("Edit This"), ' |'); ?></p>
				</li>
			<?php endforeach; ?>
		</ol>
	<?php else : // If there are no comments yet ?>
		<p><?php //_e('No comments yet.'); ?></p>
	<?php endif; 


	if ( comments_open() ) : ?>
		<h2 id="postcomment"><?php _e('Leave a comment'); ?></h2>
		<?php if ( get_option('comment_registration') && !is_user_logged_in() ) : ?>
			<p><?php printf(__('You must be <a href="%s">logged in</a> to post a comment.'), wp_login_url( get_permalink() ) );?></p>
		<?php else : ?>
			<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">
			<?php if ( is_user_logged_in() ) : ?>
				<p><?php printf(__('Logged in as %s.'), '<a href="'.get_option('siteurl').'/wp-admin/profile.php">'.$user_identity.'</a>'); ?> <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="<?php _e('Log out of this account') ?>"><?php _e('Log out &raquo;'); ?></a></p>
			<?php else : ?>
				<p><input type="text" name="author" id="author" value="<?php echo esc_attr($comment_author); ?>" size="22" tabindex="1" />
				<label for="author"><small><?php _e('Name'); ?> <?php if ($req) _e('(required)'); ?></small></label></p>
				<p><input type="text" name="email" id="email" value="<?php echo esc_attr($comment_author_email); ?>" size="22" tabindex="2" />
				<label for="email"><small><?php _e('Mail (will not be published)');?> <?php if ($req) _e('(required)'); ?></small></label></p>
				<p><input type="text" name="url" id="url" value="<?php echo esc_attr($comment_author_url); ?>" size="22" tabindex="3" />
				<label for="url"><small><?php _e('Website'); ?></small></label></p>
			<?php endif; ?>
			<!--<p><small><strong>XHTML:</strong> <?php printf(__('You can use these tags: %s'), allowed_tags()); ?></small></p>-->
			<p><textarea name="comment" id="comment" cols="100%" rows="10" tabindex="4"></textarea></p>
			<p><input name="submit" type="submit" id="submit" tabindex="5" value="<?php esc_attr_e('Submit Comment'); ?>" />
			<input type="hidden" name="comment_post_ID" value="<?php echo $id; ?>" /></p>
			<?php do_action('comment_form', $post->ID); ?>
			</form>
		<?php endif; // If registration required and not logged in ?>
	<?php else : // Comments are closed ?>
		<p><?php //_e('Sorry, the comment form is closed at this time.'); ?></p>
	<?php endif; 
} 






?>