volatile uint8_t lib_iwv_state=0, lib_iwv_timer=0, lib_iwv_ziffer=0;
/*
Lib zum Auswerten von Nummernschaltern.
Funktionen:
  void iwv_timer(void)
    Counter für die Timer Variable muss genaue einmal pro ms ausgeführt werden.
   
    uint8_t iwv_input(uint8_t nsi)
    Auswerte Rutine im main loop
    Muss mindestens alle 10ms ausgeführt werden.
    
    Return: Gewählte Ziffer    
    nsi:
      Geöffnet = 1
      Geschlossen = 0
      
  lib_iwv_timer
    Timer für die Auswertung in ms
    
  lib_iwv_ziffer
    temporärer Zähler
*/

void iwv_timer(void)
{
  // the counter should be configured to exactly 1ms.
  if(lib_iwv_timer<200){
    lib_iwv_timer++;
	  PORTC ^= 0x01;      // Toggle PC0 
  }
}

uint8_t iwv_input(uint8_t nsi) {  
  uint8_t number;
  number=0;
  
  switch(lib_iwv_state){
    case 0:            // --
    PORTC  |= (1<<PC1);
	  if(nsi==0){
	    lib_iwv_state=1; // NSI Open -> 1
	    lib_iwv_timer=0;
	  }
    break;
    case 1: // NSI Open -- already read
    PORTC  |= (1<<PC2);
	  if(lib_iwv_timer>=40 && lib_iwv_timer<50 && nsi==1){ 
	    lib_iwv_state=8; // Falschwahl
	    lib_iwv_timer=0;
	  } else if(lib_iwv_timer>=50 && lib_iwv_timer<=70 && nsi==1){  
	    lib_iwv_state=2; // NSI close -> 0
	    lib_iwv_timer=0;
	  } else if(lib_iwv_timer>70){  
	    lib_iwv_state=8; // Falschwahl
	    lib_iwv_timer=0;
	  }
    break;
    case 2: // NSI close -- set to read
    PORTC  |= (1<<PC3);
	  if(lib_iwv_timer>=20 && lib_iwv_timer<30 && nsi==0){ // stop
	    lib_iwv_state=8; // Falschwahl
	    lib_iwv_timer=0;
	  } else if(lib_iwv_timer>=30 && lib_iwv_timer<=50 && nsi==0){  // 38ms
	    lib_iwv_state=1;  // NSI Open -> 1
	    lib_iwv_timer=0;
	    lib_iwv_ziffer++; // ok
	  } else if(lib_iwv_timer>50){ 
	    lib_iwv_state=3;  // 1. Pause
	    lib_iwv_timer=0;
	    lib_iwv_ziffer++; // ok
	  }
    break;
    case 3: // 1. Pause --  > 50ms
	  if(lib_iwv_timer>=50 && lib_iwv_timer<100 && nsi==0){
	    lib_iwv_state=8; // Falschwahl
	    lib_iwv_timer=0; 
	  } else if(lib_iwv_timer>=100){
	    lib_iwv_state=4; // 2. Pause
	    lib_iwv_timer=0;
	    number=lib_iwv_ziffer;
	    lib_iwv_ziffer=0;
	  }
    break;
    case 4: // 2. Pause  -- > 100ms
	  if(lib_iwv_timer<80 && nsi==0){
	    lib_iwv_state=8; // Falschwahl
	    lib_iwv_timer=0;
	  } else if(lib_iwv_timer>=80){
	    lib_iwv_state=0;
	    lib_iwv_timer=0;
	  }
    break;
    case 8:	// -- Falschwahl
	  if(nsi==0){
	    lib_iwv_timer=0;
	  } else if(lib_iwv_timer>=180){
	    lib_iwv_state=0;
	    lib_iwv_ziffer=0;
	  }
    break;
    default:
	  lib_iwv_state=0;
    break;
  } // switch(lib_iwv_state)
    
  if(lib_iwv_ziffer>10){
    lib_iwv_state=8;
    lib_iwv_timer=0;
    lib_iwv_ziffer=0;
  }  
  return number;
}
