//***************************************************************************
//* A P P L I C A T I O N   N O T E   F O R   T H E   A V R   F A M I L Y
//*
//* Number               : AVR314
//* File Name            : "dtmf.c"
//* Title                : DTMF Generator
//* Date                 : 00.06.27
//* Version              : 1.0
//* Target MCU           : Any AVR with SRAM, 8 I/O pins and PWM 
//*
//* DESCRIPTION
//* This Application note describes how to generate DTMF tones using a single
//* 8 bit PWM output.
//*
//***************************************************************************

#include <stdio.h>
#define __IAR_SYSTEMS_ASM__   
#define  Xtal       12000000         // system clock frequency
#define  prescaler  1                // timer1 prescaler
#define  N_samples  128              // Number of samples in lookup table
#define  Fck        Xtal/prescaler   // Timer1 working frequency
#define  delaycyc   10               // port B setup delay cycles

// Samples table : one period sampled on 128 samples and
// quantized on 7 bit
const uint8_t auc_SinParam [128] PROGMEM = {
64,67,70,73,76,79,82,85,88,91,94,96,99,102,104,106,109,111,113,115,117,118,120,121,123,124,125,126,126,
127,127,127,127,127,127,127,
126,126,125,124,123,121,120,118,117,115,113,111,
109,106,104,102,99,96,94,91,88,85,82,79,
76,73,70,67,64,60,57,54,51,48,45,42,39,36,33,31,
28,25,23,21,18,16,14,12,10,9,7,6,4,3,2,1,1,0,0,0,0,0,0,0,1,1,2,3,4,6,7,9,10,12,14,16,18,21,23,25,28,31,33,36,
39,42,45,48,51,54,57,60};

//**************************  global variables  ****************************
volatile uint8_t x_SWa = 0x00;            // step width of high frequency
volatile uint8_t x_SWb = 0x00;            // step width of low frequency
volatile uint16_t  i_CurSinValA = 0;    // position freq. A in LUT (extended format)
volatile uint16_t  i_CurSinValB = 0;    // position freq. B in LUT (extended format)
volatile uint16_t  i_TmpSinValA;        // position freq. A in LUT (actual position)
volatile uint16_t  i_TmpSinValB;        // position freq. B in LUT (actual position)

// Timer overflow interrupt service routine
//**************************************************************************
void mfv_interrupt(void)
{ 
  // move Pointer about step width aheaed
  i_CurSinValA += x_SWa; // H      
  i_CurSinValB += x_SWb;
  // normalize Temp-Pointer
  i_TmpSinValA  = (char)(((i_CurSinValA+4) >> 3)&(0x007F)); 
  i_TmpSinValB  = (char)(((i_CurSinValB+4) >> 3)&(0x007F));
  // calculate PWM value: high frequency value + 3/4 low frequency value
  OCR1A = (pgm_read_byte(&auc_SinParam[i_TmpSinValA]) + (pgm_read_byte(&auc_SinParam[i_TmpSinValB])-(pgm_read_byte(&auc_SinParam[i_TmpSinValB])>>2)));
}
